% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bdpar.R
\docType{class}
\name{Bdpar}
\alias{Bdpar}
\title{Class to manage the preprocess of the files throughout the flow of pipes}
\usage{
Bdpar
}
\description{
\code{Bdpar} class provides the static variables required
to perform the whole data flow process. To this end \code{Bdpar} is
in charge of (i) loading the configuration parameters (from configurationsTemplate.ini
or the user configuration file) and (ii) executing the flow of pipes
(inherited from \code{\link{TypePipe}} class) passed as argument.
}
\section{Constructor}{

\code{Bdpar$new(configurationFilePath = NULL, editConfigurationFile = FALSE)}
\itemize{
\item{\emph{Arguments}:}{
\itemize{
\item{\strong{configurationFilePath}:}{
(\emph{character}) path where the configuration file is located. The file
must have the .ini extension. In the case that the argument is null, the
default configuration file (configurationsTemplate.ini) will be used.
}
\item{\strong{editConfigurationFile}:}{
(\emph{boolean}) indicates if open an editor to change the configuration
file or not.
}
}
}
}
}

\section{Details}{

The configuration file can be indicated by the user or use the default
configuration file (configurationsTemplate.ini). In addition, once we call
the \code{Bdpar} constructor, it will be possible to choose if the user
wants to edit the file of indicated configurations or not.

The \emph{configurationFilePath} file should have the following structure
(Depends on the Pipes used). Also the configurationsTemplate.ini has this
structure:

\strong{[twitter]}

ConsumerKey = \emph{<<consumer_key>>}

ConsumerSecret = \emph{<<consumer_secret>>}

AccessToken = \emph{<<access_token>>}

AccessTokenSecret = \emph{<<access_token_secret>>}

\strong{[youtube]}

app_id = \emph{<<app_id>>}

app_password = \emph{<<app_password>>}

\strong{[eml]}

PartSelectedOnMPAlternative = \emph{<<part_selected>>} (text/html or text/plain)

\strong{[resourcesPath]}

resourcesAbbreviationsPath = \emph{<<resources_abbreviations_path>>}

resourcesContractionsPath = \emph{<<resources_contractions_path>>}

resourcesInterjectionsPath = \emph{<<resources_interjections_path>>}

resourcesSlangsPath = \emph{<<resources_slangs_path>>}

resourcesStopWordsPath = \emph{<<resources_stopWords_path>>}

\strong{[CSVPath]}

outPutTeeCSVPipePath = \emph{<<out_put_teeCSVPipe_path>>}

\strong{[cache]}

cachePathTwtid = \emph{<<cache_path_twtid>>}

cachePathYtbid = \emph{<<cache_path_ytbid>>}
}

\section{Note}{

In the case of choosing to edit the configuration file, the default editor
will be opened.
}

\section{Static variables}{

\itemize{
\item{\bold{connections}:}{
(\emph{Connections}) object that handles the connections with YouTube and
Twitter.
}
\item{\bold{configurationFilePath}:}{
(\emph{character}) path where the configuration file is located. The file
must have the .ini extension. In the case that the argument is null, the
default configuration file (configurationsTemplate.ini) will be used.
},
\item{\bold{resourceHandler}:}{
(\emph{ResourceHandler}) object that handles the json resources files.
}
}
}

\section{Methods}{

\itemize{
\item{\bold{proccess_files}:}{
preprocess files through the indicated flow of pipes.
\itemize{
\item{\emph{Usage}:}{
\preformatted{
proccess_files(filesPath,
               pipe = SerialPipe$new(),
               instanceFactory = InstanceFactory$new())}

}
\item{\emph{Value}:}{
list of \code{Instances} that have been preprocessed.
}
\item{\emph{Arguments}:}{
\itemize{
\item{\strong{filesPath}:}{
(\emph{character}) path where the files to be processed are located.
}
\item{\strong{pipe}:}{
(\emph{TypePipe}) subclass of \code{\link{TypePipe}}, which implements the \code{pipe} method.
}
\item{\strong{instanceFactory}:}{
(\emph{InstanceFactory}) class which implements the method \code{createInstance}
to choose which type of \code{\link{Instance}} is created.
}
}
}
}
}
}
}

\examples{
\dontrun{
#Path where the configuration file are located
configurationFilePath <- system.file(file.path("examples",
                                               "configurationsExample.ini"),
                                     package ="bdpar")

#Folder with the files to preprocess
filesPath <- system.file(file.path("examples",
                                   "testFiles"),
                         package = "bdpar")

#Object which indicates the pipes' flow
pipe <- SerialPipe$new()

#Object which decides how creates the instances
instanceFactory <- InstanceFactory$new()

objectBdpar <- Bdpar$new(configurationFilePath)

#Starting file preprocessing...
objectBdpar$proccess_files(filesPath, pipe, instanceFactory)
}
}
\seealso{
\code{\link{Connections}}, \code{\link{Instance}},
\code{\link{InstanceFactory}}, \code{\link{pipeline_execute}},
\code{\link{TypePipe}}, \code{\link{SerialPipe}}
}
