% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorFactory.R
\name{ExtractorFactory}
\alias{ExtractorFactory}
\title{Class to handle the creation of Instance types}
\description{
\code{\link{ExtractorFactory}} class builds the appropriate
\code{\link{Instance}} object according to the file extension. In the case
of not finding the registered extension, the default extractor will be used
if it has been previously configured.
}
\seealso{
\code{\link{ExtractorEml}}, \code{\link{ExtractorSms}},
\code{\link{ExtractorTwtid}}, \code{\link{ExtractorYtbid}},
\code{\link{Instance}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ExtractorFactory$new()}}
\item \href{#method-registerExtractor}{\code{ExtractorFactory$registerExtractor()}}
\item \href{#method-setExtractor}{\code{ExtractorFactory$setExtractor()}}
\item \href{#method-setDefaultExtractor}{\code{ExtractorFactory$setDefaultExtractor()}}
\item \href{#method-removeExtractor}{\code{ExtractorFactory$removeExtractor()}}
\item \href{#method-getAllExtractors}{\code{ExtractorFactory$getAllExtractors()}}
\item \href{#method-getDefaultExtractor}{\code{ExtractorFactory$getDefaultExtractor()}}
\item \href{#method-isSpecificExtractor}{\code{ExtractorFactory$isSpecificExtractor()}}
\item \href{#method-createInstance}{\code{ExtractorFactory$createInstance()}}
\item \href{#method-reset}{\code{ExtractorFactory$reset()}}
\item \href{#method-print}{\code{ExtractorFactory$print()}}
\item \href{#method-clone}{\code{ExtractorFactory$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ExtractorFactory}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-registerExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-registerExtractor}{}}}
\subsection{Method \code{registerExtractor()}}{
Adds an extractor to the list of extensions. If the extension
is an empty string (""), the indicated extractor will be the default
when there is no extractor associated with an extension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$registerExtractor(extensions, extractor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extensions}}{A \code{\link{character}} array. The names of the
extension option.}

\item{\code{extractor}}{A \code{Object} value. The extractor of the new
extension.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-setExtractor}{}}}
\subsection{Method \code{setExtractor()}}{
Modifies the extractor of the one extension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$setExtractor(extension, extractor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extension}}{A \code{\link{character}} value. The name of the
extension option.}

\item{\code{extractor}}{A \code{Object} value. The value of the new
extractor.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setDefaultExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-setDefaultExtractor}{}}}
\subsection{Method \code{setDefaultExtractor()}}{
Modifies the extractor of the one extension. Assign NULL
value to disable the default extractor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$setDefaultExtractor(defaultExtractor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{defaultExtractor}}{A \code{Object} value. The value of the default
extractor.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-removeExtractor}{}}}
\subsection{Method \code{removeExtractor()}}{
Removes a specific extractor thought the extension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$removeExtractor(extension)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extension}}{A \code{\link{character}} value. The name of the
extension to remove.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getAllExtractors"></a>}}
\if{latex}{\out{\hypertarget{method-getAllExtractors}{}}}
\subsection{Method \code{getAllExtractors()}}{
Gets the list of extractors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$getAllExtractors()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of extractors.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDefaultExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-getDefaultExtractor}{}}}
\subsection{Method \code{getDefaultExtractor()}}{
Gets the default extractor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$getDefaultExtractor()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of default extractor.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isSpecificExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-isSpecificExtractor}{}}}
\subsection{Method \code{isSpecificExtractor()}}{
Checks if exists an extractor for a specific extension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$isSpecificExtractor(extension)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extension}}{A \code{\link{character}} value. The name of the
extension to check}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value of extractors.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createInstance"></a>}}
\if{latex}{\out{\hypertarget{method-createInstance}{}}}
\subsection{Method \code{createInstance()}}{
Builds the \code{\link{Instance}} object according to the
file extension. In the case of not finding the registered extension, the
default extractor will be used if it has been previously configured.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$createInstance(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. Path of the file to create
an \code{\link{Instance}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} corresponding object according to the
file extension.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Resets list of extractor to default state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints pipeline representation. (Override print function)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Further arguments passed to or from other methods.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
