% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_jar_path.R
\name{is_jar_path}
\alias{is_jar_path}
\title{Is the path a path to the BEAST2 jar file?
Does not check if the file at that path is present}
\usage{
is_jar_path(path)
}
\arguments{
\item{path}{a string to a path}
}
\value{
TRUE if the path is a path to a BEAST2 jar file
}
\description{
Is the path a path to the BEAST2 jar file?
Does not check if the file at that path is present
}
\examples{
  library(testthat)

  expect_false(is_jar_path("beast"))
  expect_true(is_jar_path("beast.jar"))
  expect_true(is_jar_path("launcher.jar"))
  expect_false(is_jar_path(get_default_beast2_bin_path()))
  expect_true(is_jar_path(get_default_beast2_jar_path()))
}
\author{
Richèl J.C. Bilderbeek
}
