% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock_models_to_xml_state.R
\name{clock_models_to_xml_state}
\alias{clock_models_to_xml_state}
\title{Converts one or more clock models to the \code{state} section of the
XML as text}
\usage{
clock_models_to_xml_state(
  clock_models,
  mrca_priors = NA,
  has_tip_dating = FALSE
)
}
\arguments{
\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}

\item{has_tip_dating}{TRUE if the user has supplied tip dates,
FALSE otherwise}
}
\value{
lines of XML text, without indentation nor \code{state}
  tags
}
\description{
Converts one or more clock models to the \code{state} section of the
XML as text
}
\author{
Richèl J.C. Bilderbeek
}
