% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_clock_model.R
\name{create_strict_clock_model}
\alias{create_strict_clock_model}
\alias{create_clock_model_strict}
\title{Create a strict clock model}
\usage{
create_strict_clock_model(
  id = NA,
  clock_rate_param = create_clock_rate_param(),
  clock_rate_distr = create_uniform_distr()
)
}
\arguments{
\item{id}{an alignment's IDs.
An ID can be extracted from its FASTA filename
with \code{\link{get_alignment_ids_from_fasta_filenames}})}

\item{clock_rate_param}{the clock rate's parameter,
a numeric value.
For advanced usage, use the structure
as created by the \code{\link{create_clock_rate_param}} function}

\item{clock_rate_distr}{the clock rate's distribution,
as created by a \code{\link{create_distr}} function}
}
\value{
a strict clock_model
}
\description{
Create a strict clock model
}
\examples{
strict_clock_model <- create_strict_clock_model(
  clock_rate_param = 1.0,
  clock_rate_distr = create_uniform_distr()
)

beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  get_fasta_filename(),
  beast2_input_file,
  clock_model = strict_clock_model
)
file.remove(beast2_input_file)

strict_clock_model_gamma <- create_strict_clock_model(
  clock_rate_distr = create_gamma_distr()
)

beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  get_fasta_filename(),
  beast2_input_file,
  clock_model = strict_clock_model_gamma
)
file.remove(beast2_input_file)
}
\author{
Richèl J.C. Bilderbeek
}
