% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree_likelihood_distr_xml.R
\name{create_tree_likelihood_distr_xml}
\alias{create_tree_likelihood_distr_xml}
\title{Creates the XML text for the \code{distribution} tag
with the \code{treeLikelihood} ID,
of a BEAST2 parameter file.}
\usage{
create_tree_likelihood_distr_xml(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\description{
Creates the XML text for the \code{distribution} tag
with the \code{treeLikelihood} ID,
of a BEAST2 parameter file,
in an unindented form
}
\details{
The \code{distribution} tag (with ID equals \code{treeLikelihood})
has these elements:

\preformatted{
   <distribution id="treeLikelihood"[...]>
      <siteModel[...]>
        [...]
      </siteModel>
      <branchRateModel[...]>
        [...]
      </branchRateModel>
   </distribution>
}

The \code{siteModel} section
is created by \link{create_site_model_xml}.
The \code{branchRateModel} section
is created by \link{create_branch_rate_model_xml}.

Zooming out:

\preformatted{
  <beast[...]>
    <run[...]>
      <distribution id="posterior"[...]>
        <distribution id="likelihood"[...]>
          [this section]
        </distribution>
      </distribution>
    </run>
  </beast>
}
}
\note{
this function is not intended for regular use, thus its
  long name length is accepted
}
\seealso{
this function is called by \code{create_beast2_input_distr},
  together with \code{create_beast2_input_distr_prior}
}
\author{
Richèl J.C. Bilderbeek
}
