% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/site_model_to_xml_lh_distr.R
\name{site_model_to_xml_lh_distr}
\alias{site_model_to_xml_lh_distr}
\title{Creates the XML text for the \code{siteModel} tag
of a BEAST2 parameter file.}
\usage{
site_model_to_xml_lh_distr(inference_model, site_model = "deprecated")
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}

\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}
}
\value{
the site model as XML text
}
\description{
Creates the XML text for the \code{siteModel} tag of
a BEAST2 parameter file,
which is part of the \code{distribution} node for the
\code{treeLikelihood} ID.
}
\details{
The \code{siteModel} tag has these elements:

\preformatted{
  <siteModel[...]>
      [parameters]
  </siteModel>
}
}
\examples{
 # <distribution id="posterior"[...]">
 #     <distribution id="likelihood" [...]>
 #       <siteModel...>
 #         [parameters]
 #       </siteModel>
 #     </distribution>
 # </distribution>
}
\author{
Richèl J.C. Bilderbeek
}
