% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aic.R
\name{AIC.bellreg}
\alias{AIC.bellreg}
\title{Akaike information criterion}
\usage{
\method{AIC}{bellreg}(object, ..., k = 2)
}
\arguments{
\item{object}{an object of the class bellreg.}

\item{...}{further arguments passed to or from other methods.}

\item{k}{numeric, the penalty per parameter to be used; the default k = 2 is the classical AIC.}
}
\value{
the Akaike information criterion value when a single model is passed to the function; otherwise, a data.frame with the Akaike information criterion values and the number of parameters is returned.
}
\description{
Akaike information criterion
}
\examples{
\donttest{
library(bellreg)
data(faults)
fit1 <- bellreg(nf ~ 1, data = faults, approach = "mle")
fit2 <- bellreg(nf ~ lroll, data = faults, approach = "mle")
AIC(fit1, fit2)
}

}
