% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-methods-beta-nb.R
\name{summary.betanb}
\alias{summary.betanb}
\title{Summary Method for an Object of Class
\code{betanb}}
\usage{
\method{summary}{betanb}(object, alpha = c(0.05, 0.01, 0.001), type = "pc", digits = 4, ...)
}
\arguments{
\item{object}{Object of Class \code{betanb},
that is,
the output of the
\code{BetaNB()},
\code{RSqNB()},
\code{SCorNB()},
\code{DeltaRSqNB()}, or
\code{PCorNB()}
functions.}

\item{alpha}{Significance level.}

\item{type}{Charater string.
Confidence interval type, that is,
\code{type = "pc"} for percentile;
\code{type = "bc"} for bias corrected;
\code{type = "bca"} for bias corrected and accelerated.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of
estimates,
standard errors,
number of bootstrap replications,
and
confidence intervals.
}
\description{
Summary Method for an Object of Class
\code{betanb}
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate bootstrap covariance matrices
# (use a large R, for example, R = 5000 for actual research)
nb <- NB(object, R = 50)
# Generate confidence intervals for standardized regression slopes
std <- BetaNB(nb)
# Method ---------------------------------------------------------
summary(std, type = "pc")
summary(std, type = "bc")
summary(std, type = "bca")
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
