% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdf_ftf.R
\docType{data}
\name{flex_t24_lst}
\alias{flex_t24_lst}
\title{A list of all 24-hour flexible time types}
\format{
An object of class \code{list} of length 8.
}
\usage{
flex_t24_lst
}
\value{
A list where each element corresponds to a classifier for a 24-hour
flexible time type.
}
\description{
The \code{flex_t24_lst} object is a list of the 24-hour flexible time types which
are widely supported. Flexible time types are classes of time formatting
which can be translated across locales. There are 8
flexible time types of the 24-hour variety in \code{flex_t24_lst}.
}
\section{Examples}{


The \code{flex_t24_lst} object can be incredibly useful when you need to get a
format for 24-hour time formatting that works across all locales. You can
avoid typing errors by using this list and every flexible time type from this
list is guaranteed to work across all supported locales. In this example,
we'll use the \code{"EHms"} flexible time type by accessing it from the
\code{flex_t24_lst} object.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fdt(
  input = "2018-07-04 22:05",
  format = flex_t24_lst$EHms,
  locale = "en"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "Wed 22:05:00"
}\if{html}{\out{</div>}}

If we wanted this in a different locale, the locale-specific \code{format} pattern
behind the flexible date identifier would ensure consistency while moving to
that locale. Let's use the \code{fdt_locales_lst} object in the same spirit to
specify the German locale.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fdt(
  input = "2018-07-04 22:05",
  format = flex_t24_lst$EHms,
  locale = fdt_locales_lst$de
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "Mi, 22:05:00"
}\if{html}{\out{</div>}}
}

\keyword{datasets}
