% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{dgemm}
\alias{dgemm}
\title{Matrix Multiply}
\usage{
dgemm(
  TRANSA = "N",
  TRANSB = "N",
  M = NULL,
  N = NULL,
  K = NULL,
  ALPHA = 1,
  A,
  LDA = NULL,
  B,
  LDB = NULL,
  BETA = 0,
  C,
  LDC = NULL,
  COFF = 0
)
}
\arguments{
\item{TRANSA}{a character. TRANSA specifies the form of op( A ) to be used in the matrix multiplication as follows:
\describe{
  \item{TRANSA =}{ 'N' or 'n',  op( A ) = A.}
  \item{TRANSA =}{ 'T' or 't',  op( A ) = A**T.}
  \item{TRANSA =}{ 'C' or 'c',  op( A ) = A**T.}
}}

\item{TRANSB}{a character. TRANSB specifies the form of op( B ) to be used in the matrix multiplication as follows:
#' \describe{
  \item{TRANSA =}{ 'N' or 'n',  op( B ) = B.}
  \item{TRANSA =}{ 'T' or 't',  op( B ) = B**T.}
  \item{TRANSA =}{ 'C' or 'c',  op( B ) = B**T.}
}}

\item{M}{an integer. M specifies the number of rows  of the  matrix op( A )  and of the  matrix  C.  M  must  be at least  zero.}

\item{N}{an integer. N specifies the number of columns  of the  matrix op( B )  and of the  matrix  C.  N  must  be at least  zero.}

\item{K}{an integer. K specifies the number of columns  of the  matrix op( A )  and the number of rows of the  matrix  op( B ).  K  must  be at least  zero.}

\item{ALPHA}{a real number. Specifies the scalar alpha.}

\item{A}{a matrix of dimension (LDA, ka), where ka is k  when  TRANSA = 'N' or 'n',  and is  m  otherwise. Before entry with  TRANSA = 'N' or 'n',  the leading  m by k part of the array  A  must contain the matrix  A,  otherwise the leading  k by m  part of the array  A  must contain  the matrix A.}

\item{LDA}{an integer.}

\item{B}{a matrix of dimension ( LDB, kb ), where kb is n  when  TRANSB = 'N' or 'n',  and is  k  otherwise. Before entry with  TRANSB = 'N' or 'n',  the leading  k by n part of the array  B  must contain the matrix  B,  otherwise the leading  n by k  part of the array  B  must contain  the matrix B.}

\item{LDB}{an integer.}

\item{BETA}{a real number. Specifies the scalar beta}

\item{C}{a matrix of dimension ( LDC, N ). Before entry, the leading  m by n  part of the array  C must contain the matrix  C,  except when  beta  is zero, in which case C need not be set on entry. On exit, the array  C  is overwritten by the  m by n  matrix ( alpha*op( A )*op( B ) + beta*C ).}

\item{LDC}{an integer.}

\item{COFF}{offset for C.}
}
\value{
Update C with the result.
}
\description{
This is function provides dgemm functionality, which DGEMM 
performs one of the matrix-matrix operations.
C := ALPHA * op(A) * op(B) + BETA * C.
}
\examples{
require(bigmemory)
A = as.big.matrix(matrix(1, nrow=3, ncol=2))
B <- big.matrix(2, 3, type="double", init=-1,
                dimnames=list(NULL, c("alpha", "beta")), shared=FALSE)
C = big.matrix(3, 3, type="double", init=1,
               dimnames=list(NULL, c("alpha", "beta", "gamma")), shared=FALSE)  
2*A[,]\%*\%B[,]+0.5*C[,]
E = dgemm(ALPHA=2.0, A=A, B=B, BETA=0.5, C=C)
E[,] # Same result

# The big.matrix file backings will be deleted when garbage collected.
rm(A,B,C,E)
gc()
}
