% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy_balance.r
\name{biochemical.energy}
\alias{biochemical.energy}
\title{Biochemical Energy}
\usage{
biochemical.energy(NEE, alpha = 0.422)
}
\arguments{
\item{NEE}{Net ecosystem exchange (umol CO2 m-2 s-1)}

\item{alpha}{Energy taken up/released by photosynthesis/respiration per mol CO2 fixed/respired (J umol-1)}
}
\value{
\item{Sp -}{biochemical energy (W m-2)}
}
\description{
Radiant energy absorbed in photosynthesis or heat release by respiration calculated
             from net ecosystem exchange of CO2 (NEE).
}
\details{
The following sign convention is employed: NEE is negative when carbon is taken up by the ecosystem.
         Positive values of the resulting biochemical energy mean that energy (heat) is taken up by the ecosystem, 
         negative ones that heat is released.
         The value of alpha is taken from Nobel 1974 (see Meyers & Hollinger 2004), but other values
         have been used (e.g. Blanken et al., 1997)
}
\examples{
# Calculate biochemical energy taken up by the ecosystem with 
# a measured NEE of -30umol CO2 m-2 s-1             
biochemical.energy(NEE=-30)            
           
}
\references{
Meyers, T.P., Hollinger, S.E. 2004: An assessment of storage terms in the surface energy
            balance of maize and soybean. Agricultural and Forest Meteorology 125, 105-115.
            
            Nobel, P.S., 1974: Introduction to Biophysical Plant Physiology.
            Freeman, New York.
            
            Blanken, P.D. et al., 1997: Energy balance and canopy conductance of a boreal aspen
            forest: Partitioning overstory and understory components. 
            Journal of Geophysical Research 102, 28915-28927.
}
