% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface_roughness.r
\name{Reynolds.Number}
\alias{Reynolds.Number}
\title{Roughness Reynolds Number}
\usage{
Reynolds.Number(Tair, pressure, ustar, z0m,
  constants = bigleaf.constants())
}
\arguments{
\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{ustar}{Friction velocity (m s-1)}

\item{z0m}{Roughness length (m)}

\item{constants}{Kelvin - conversion degree Celsius to Kelvin \cr
pressure0 - reference atmospheric pressure at sea level (Pa) \cr
Tair0 - reference air temperature (K)}
}
\value{
\item{Re -}{Roughness Reynolds Number (-)}
}
\description{
calculates the Roughness Reynolds Number.
}
\details{
The Roughness Reynolds Number is calculated as in Massman 1999a:
         
           \deqn{Re = z0m * ustar / v}
         
         where \code{v} is the kinematic viscosity (m2 s-1).
}
\examples{
Reynolds.Number(25,100,0.5,z0m=0.5)                             

}
\references{
Massman, W.J., 1999a: A model study of kB H- 1 for vegetated surfaces using
           'localized near-field' Lagrangian theory. Journal of Hydrology 223, 27-43.
}
