\name{createSource}
\alias{createSource}
\title{Creating BigML Sources}
\usage{
  createSource(file_name, name = basename(file_name),
    header = TRUE, locale = "en-US",
    missing_tokens = c("NA"), quote = "\"",
    separator = ",", trim = TRUE, flatten = TRUE, ...)
}
\arguments{
  \item{file_name}{A string giving a file location}

  \item{name}{A string specifying the name of the source}

  \item{header}{logical; TRUE if data contains name
  information, false otherwise.}

  \item{locale}{A string giving the locale (defaults to
  en-US).}

  \item{missing_tokens}{A vector of character strings that
  will be used to specify missing values in a file name.}

  \item{quote}{A string specifying the quoting character
  used.}

  \item{separator}{the separator character used when a file
  name is specified.}

  \item{trim}{A logical value indicating whether white
  space should be trimmed.}

  \item{flatten}{A logical value indicating whether or not
  the returned field objects should be "flattened" into a
  data frame.}

  \item{\dots}{Arbitrary named arguments that are passed on
  to \code{\link{formEncodeURL}} in order to create
  form-encoded URL options.}
}
\value{
  \item{category}{numeric} \item{code}{numeric}
  \item{content_type}{character} \item{created}{character}
  \item{credits}{numeric} \item{description}{character}
  \item{fields}{data.frame (or list if flatten=FALSE)}
  \item{file_name}{character} \item{md5}{character}
  \item{name}{character} \item{number_of_datasets}{numeric}
  \item{number_of_models}{numeric}
  \item{number_of_predictions}{numeric}
  \item{private}{logical} \item{resource}{character}
  \item{size}{numeric} \item{source_parser}{list}
  \item{status}{list} \item{tags}{AsIs}
  \item{type}{numeric} \item{updated}{character}
}
\description{
  Creating BigML Sources
}
\details{
  createSource
}
\note{
  While all BigML API functions are asynchronous, this
  function will continue polling the BigML API until the
  operation is complete.
}
\examples{
\dontrun{
# simple example
m1 = createSource("/tmp/iris.csv")

}
}
\author{
  Justin Donaldson \email{donaldson@bigml.com}
}
\references{
  \url{https://bigml.com/developers/sources}
}
\seealso{
  Other source methods: \code{\link{getSource}},
  \code{\link{listSources}}, \code{\link{quickSource}}
}

