% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRS.R
\name{snp_PRS}
\alias{snp_PRS}
\title{PRS}
\usage{
snp_PRS(G, betas.keep, ind.test = rows_along(G), ind.keep = cols_along(G),
  same.keep = rep(TRUE, length(ind.keep)), lpS.keep = NULL, thr.list = 0)
}
\arguments{
\item{G}{A \link[=FBM.code256-class]{FBM.code256}
(typically \code{<bigSNP>$genotypes}).\cr
\strong{You shouldn't have missing values in your data or SNPs with 0 MAF.}}

\item{betas.keep}{Numeric vector of weights associated with each SNP
corresponding to \code{ind.keep}.
You may want to see \link{big_univLinReg} or \link{big_univLogReg}.}

\item{ind.test}{The individuals on whom to project the scores. Default uses all.}

\item{ind.keep}{Column (SNP) indices to use (if using clumping, the
output of \link{snp_clumping}). Default doesn't clump.}

\item{same.keep}{A logical vector associated with \code{betas.keep} whether the
reference allele is the same for G. Default is all \code{TRUE} (for example when
you train the betas on the same dataset). Otherwise, use \link{same_ref}.}

\item{lpS.keep}{Numeric vector of \code{-log10(p.value)} associated with
\code{betas.keep}. Default doesn't use thresholding.}

\item{thr.list}{Threshold vector on \code{lpS.keep} at which SNPs are excluded if
they are not significant enough. Default doesn't use thresholding.}
}
\value{
A matrix of scores, where rows correspond to \code{ind.test} and
columns correspond to \code{thr.list}.
}
\description{
Polygenic Risk Scores with possible clumping and thresholding.
}
\examples{
test <- snp_attachExtdata()
G <- big_copy(test$genotypes, ind.col = 1:1000)
CHR <- test$map$chromosome[1:1000]
POS <- test$map$physical.position[1:1000]
y01 <- test$fam$affection - 1

# PCA -> covariables
obj.svd <- snp_autoSVD(G, infos.chr = CHR, infos.pos = POS)

# train and test set
ind.train <- sort(sample(nrow(G), 400))
ind.test <- setdiff(rows_along(G), ind.train) # 117

# GWAS
gwas.train <- big_univLogReg(G, y01.train = y01[ind.train],
                             ind.train = ind.train,
                             covar.train = obj.svd$u[ind.train, ])
# clumping
ind.keep <- snp_clumping(G, infos.chr = CHR,
                         ind.row = ind.train,
                         S = abs(gwas.train$score))
# -log10(p-values) and thresolding
summary(lpS.keep <- -predict(gwas.train)[ind.keep])
thrs <- seq(0, 4, by = 0.5)
nb.pred <- sapply(thrs, function(thr) sum(lpS.keep > thr))

# PRS
prs <- snp_PRS(G, betas.keep = gwas.train$estim[ind.keep],
               ind.test = ind.test,
               ind.keep = ind.keep,
               lpS.keep = lpS.keep,
               thr.list = thrs)

# AUC as a function of the number of predictors
aucs <- apply(prs, 2, AUC, target = y01[ind.test])
library(ggplot2)
bigstatsr:::MY_THEME(qplot(nb.pred, aucs)) +
  geom_line() +
  scale_x_log10(breaks = nb.pred) +
  labs(x = "Number of predictors", y = "AUC")

}
