% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external-software.R
\name{snp_plinkIBDQC}
\alias{snp_plinkIBDQC}
\title{Identity-by-descent}
\usage{
snp_plinkIBDQC(
  plink.path,
  bedfile.in,
  bedfile.out = NULL,
  pi.hat = 0.08,
  ncores = 1,
  pruning.args = c(100, 0.2),
  do.blind.QC = TRUE,
  extra.options = "",
  verbose = TRUE
)
}
\arguments{
\item{plink.path}{Path to the executable of PLINK 1.9.}

\item{bedfile.in}{Path to the input bedfile.}

\item{bedfile.out}{Path to the output bedfile. Default is created by
appending \code{"_norel"} to \code{prefix.in} (\code{bedfile.in} without extension).}

\item{pi.hat}{PI_HAT value threshold for individuals (first by pairs)
to be excluded. Default is \code{0.08}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{pruning.args}{A vector of 2 pruning parameters, respectively
the window size (in variant count) and the pairwise $r^2$ threshold
(the step size is fixed to 1). Default is \code{c(100, 0.2)}.}

\item{do.blind.QC}{Whether to do QC with \code{pi.hat} without visual inspection.
Default is \code{TRUE}. If \code{FALSE}, return the \code{data.frame} of the corresponding
".genome" file without doing QC. One could use
\code{ggplot2::qplot(Z0, Z1, data = mydf, col = RT)} for visual inspection.}

\item{extra.options}{Other options to be passed to PLINK as a string
(for the IBD part). More options can be found at
\url{https://www.cog-genomics.org/plink/1.9/ibd}.}

\item{verbose}{Whether to show PLINK log? Default is \code{TRUE}.}
}
\value{
The path of the new bedfile.
If no sample is filter, no new bed/bim/fam files are created and
then the path of the input bedfile is returned.
}
\description{
Quality Control based on Identity-by-descent (IBD) computed by
\href{https://www.cog-genomics.org/plink2}{\strong{PLINK 1.9}}
using its method-of-moments.
}
\examples{
\dontrun{

bedfile <- system.file("extdata", "example.bed", package = "bigsnpr")
plink <- download_plink()

bedfile <- snp_plinkIBDQC(plink, bedfile,
                          bedfile.out = tempfile(fileext = ".bed"),
                          ncores = 2)

df_rel <- snp_plinkIBDQC(plink, bedfile, do.blind.QC = FALSE, ncores = 2)
str(df_rel)

library(ggplot2)
qplot(Z0, Z1, data = df_rel, col = RT)
qplot(y = PI_HAT, data = df_rel) +
  geom_hline(yintercept = 0.2, color = "blue", linetype = 2)
snp_plinkRmSamples(plink, bedfile,
                   bedfile.out = tempfile(fileext = ".bed"),
                   df.or.files = subset(df_rel, PI_HAT > 0.2))
}

}
\references{
Chang, Christopher C, Carson C Chow, Laurent CAM Tellier,
Shashaank Vattikuti, Shaun M Purcell, and James J Lee. 2015.
\emph{Second-generation PLINK: rising to the challenge of larger and richer
datasets.} GigaScience 4 (1): 7. \doi{10.1186/s13742-015-0047-8}.
}
\seealso{
\link{download_plink} \link{snp_plinkQC} \link{snp_plinkKINGQC}
}
