% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external-software.R
\name{snp_plinkKINGQC}
\alias{snp_plinkKINGQC}
\title{Relationship-based pruning}
\usage{
snp_plinkKINGQC(
  plink2.path,
  bedfile.in,
  bedfile.out = NULL,
  thr.king = 2^-3.5,
  make.bed = TRUE,
  ncores = 1,
  extra.options = "",
  verbose = TRUE
)
}
\arguments{
\item{plink2.path}{Path to the executable of PLINK 2.}

\item{bedfile.in}{Path to the input bedfile.}

\item{bedfile.out}{Path to the output bedfile. Default is created by
appending \code{"_norel"} to \code{prefix.in} (\code{bedfile.in} without extension).}

\item{thr.king}{Note that KING kinship coefficients are scaled such that
duplicate samples have kinship 0.5, not 1. First-degree relations
(parent-child, full siblings) correspond to ~0.25, second-degree relations
correspond to ~0.125, etc. It is conventional to use a cutoff of ~0.354
(2^-1.5, the geometric mean of 0.5 and 0.25) to screen for monozygotic
twins and duplicate samples, ~0.177 (2^-2.5) to remove first-degree
relations as well, and ~0.0884 (2^-3.5, \strong{default}) to remove
second-degree relations as well, etc.}

\item{make.bed}{Whether to create new bed/bim/fam files (default).
Otherwise, returns a table with coefficients of related pairs.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{extra.options}{Other options to be passed to PLINK2 as a string.}

\item{verbose}{Whether to show PLINK log? Default is \code{TRUE}.}
}
\value{
See parameter \code{make-bed}.
}
\description{
Quality Control based on KING-robust kinship estimator. More information can
be found at \url{http://www.cog-genomics.org/plink/2.0/distance#king_cutoff}.
}
\examples{
\dontrun{

bedfile <- system.file("extdata", "example.bed", package = "bigsnpr")
plink2 <- download_plink2(AVX2 = FALSE)

bedfile2 <- snp_plinkKINGQC(plink2, bedfile,
                            bedfile.out = tempfile(fileext = ".bed"),
                            ncores = 2)

df_rel <- snp_plinkKINGQC(plink2, bedfile, make.bed = FALSE, ncores = 2)
str(df_rel)
}

}
\references{
Manichaikul, Ani, Josyf C. Mychaleckyj, Stephen S. Rich, Kathy Daly,
Michele Sale, and Wei-Min Chen. "Robust relationship inference in genome-wide
association studies." Bioinformatics 26, no. 22 (2010): 2867-2873.
}
\seealso{
\link{download_plink2} \link{snp_plinkQC}
}
