% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu-pheno.R
\name{snp_simuPheno}
\alias{snp_simuPheno}
\title{Simulate phenotypes}
\usage{
snp_simuPheno(
  G,
  h2,
  M,
  K = NULL,
  ind.row = rows_along(G),
  ind.possible = cols_along(G),
  effects.dist = c("gaussian", "laplace"),
  ncores = 1
)
}
\arguments{
\item{G}{A \link[=FBM.code256-class]{FBM.code256}
(typically \verb{<bigSNP>$genotypes}).\cr
\strong{You shouldn't have missing values.} Also, remember to do quality control,
e.g. some algorithms in this package won't work if you use SNPs with 0 MAF.}

\item{h2}{Heritability.}

\item{M}{Number of causal variants.}

\item{K}{Prevalence. Default is \code{NULL}, giving a continuous trait.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.possible}{Indices of possible causal variants.}

\item{effects.dist}{Distribution of effects.
Either \code{"gaussian"} (the default) or \code{"laplace"}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}
}
\value{
A list with 3 elements:
\itemize{
\item \verb{$pheno}: vector of phenotypes,
\item \verb{$set}: indices of causal variants,
\item \verb{$effects}: effect sizes (of scaled genotypes) corresponding to \code{set}.
}
}
\description{
Simulate phenotypes using a linear model. When a prevalence is given, the
liability threshold is used to convert liabilities to a binary outcome.
The genetic and environmental liabilities are scaled such that the variance
of the genetic liability is exactly equal to the requested heritability, and
the variance of the total liability is equal to 1.
}
