% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDpred2.R
\name{snp_ldpred2_inf}
\alias{snp_ldpred2_inf}
\alias{snp_ldpred2_grid}
\alias{snp_ldpred2_auto}
\title{LDpred2}
\usage{
snp_ldpred2_inf(corr, df_beta, h2)

snp_ldpred2_grid(
  corr,
  df_beta,
  grid_param,
  burn_in = 50,
  num_iter = 100,
  ncores = 1,
  return_sampling_betas = FALSE
)

snp_ldpred2_auto(
  corr,
  df_beta,
  h2_init,
  vec_p_init = 0.1,
  burn_in = 500,
  num_iter = 200,
  sparse = FALSE,
  verbose = FALSE,
  report_step = num_iter + 1L,
  allow_jump_sign = TRUE,
  shrink_corr = 1,
  ncores = 1
)
}
\arguments{
\item{corr}{Sparse correlation matrix as an \link[=SFBM-class]{SFBM}.
If \code{corr} is a dsCMatrix or a dgCMatrix, you can use \code{as_SFBM(corr)}.}

\item{df_beta}{A data frame with 3 columns:
\itemize{
\item \verb{$beta}: effect size estimates
\item \verb{$beta_se}: standard errors of effect size estimates
\item \verb{$n_eff}: sample size when estimating \code{beta}
(in the case of binary traits, this is \code{4 / (1 / n_control + 1 / n_case)})
}}

\item{h2}{Heritability estimate.}

\item{grid_param}{A data frame with 3 columns as a grid of hyper-parameters:
\itemize{
\item \verb{$p}: proportion of causal variants
\item \verb{$h2}: heritability (captured by the variants used)
\item \verb{$sparse}: boolean, whether a sparse model is sought
They can be run in parallel by changing \code{ncores}.
}}

\item{burn_in}{Number of burn-in iterations.}

\item{num_iter}{Number of iterations after burn-in.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{return_sampling_betas}{Whether to return all sampling betas (after
burn-in)? This is useful for assessing the uncertainty of the PRS at the
individual level (see \doi{10.1101/2020.11.30.403188}).
Default is \code{FALSE} (only returns the averaged final vectors of betas).
If \code{TRUE}, only one set of parameters is allowed.}

\item{h2_init}{Heritability estimate for initialization.}

\item{vec_p_init}{Vector of initial values for p. Default is \code{0.1}.}

\item{sparse}{In LDpred2-auto, whether to also report a sparse solution by
running LDpred2-grid with the estimates of p and h2 from LDpred2-auto, and
sparsity enabled. Default is \code{FALSE}.}

\item{verbose}{Whether to print "p // h2" estimates at each iteration.
Disabled when parallelism is used.}

\item{report_step}{Step to report sampling betas (after burn-in and before
unscaling). Nothing is reported by default. If using \code{num_iter = 200} and
\code{report_step = 20}, then 10 vectors of betas are reported.}

\item{allow_jump_sign}{Whether to allow for effects sizes to change sign in
consecutive iterations? Default is \code{TRUE} (normal sampling). You can use
\code{FALSE} to force effects to go through 0 first before changing sign. Setting
this parameter to \code{FALSE} could be useful to prevent instability (oscillation
and ultimately divergence) of the Gibbs sampler. This would also be useful
for accelerating convergence of chains with a large initial value for p.}

\item{shrink_corr}{Shrinkage multiplicative coefficient to apply to off-diagonal
elements of the correlation matrix. Default is \code{1} (unchanged).
You can use e.g. \code{0.9}.}
}
\value{
\code{snp_ldpred2_inf}: A vector of effects, assuming an infinitesimal model.

\code{snp_ldpred2_grid}: A matrix of effect sizes, one vector (column)
for each row of \code{grid_param}. Missing values are returned when strong
divergence is detected. If using \code{return_sampling_betas}, each column
corresponds to one iteration instead (after burn-in).

\code{snp_ldpred2_auto}: A list (over \code{vec_p_init}) of lists with
\itemize{
\item \verb{$beta_est}: vector of effect sizes (on the allele scale)
\item \verb{$beta_est_sparse} (only when \code{sparse = TRUE}): sparse vector of effect sizes
\item \verb{$corr_est}, the "imputed" correlations between variants and phenotypes,
which can be used for post-QCing variants by comparing those to
\code{with(df_beta, beta / sqrt(n_eff * beta_se^2 + beta^2))}
\item \verb{$sample_beta}: Matrix of sampling betas (see parameter \code{report_step}),
\emph{not} on the allele scale, for which you need to multiply by
\code{with(df_beta, sqrt(n_eff * beta_se^2 + beta^2))}
\item \verb{$postp_est}: vector of posterior probabilities of being causal
\item \verb{$p_est}: estimate of p, the proportion of causal variants
\item \verb{$h2_est}: estimate of the (SNP) heritability (also see \link{coef_to_liab})
\item \verb{$path_p_est}: full path of p estimates (including burn-in);
useful to check convergence of the iterative algorithm
\item \verb{$path_h2_est}: full path of h2 estimates (including burn-in);
useful to check convergence of the iterative algorithm
\item \verb{$h2_init} and \verb{$p_init}, input parameters for convenience
}
}
\description{
LDpred2. Tutorial at \url{https://privefl.github.io/bigsnpr/articles/LDpred2.html}.
}
