print.summary.ssg <- 
  function(x,digits=4,...){
    
    x$info=round(x$info,digits)
    if(is.null(x$residuals)){
      cat("\nFamily:\n")
      cat(x$family,"\n")
      cat("\nCall:\n")
      print(x$call)
      cat("\nDispersion Estimate:\n")
      cat(x$dispersion," on ",as.numeric(x$n-x$df)," degrees of freedom","\n")
      cat("\nFit Statistics:")
      cat("\nGCV:  ",x$info[1])
      cat("\nR^2:  ",x$info[2])
      cat("\nAIC:  ",x$info[3])
      cat("\nBIC:  ",x$info[4])
      cat("\nDev:  ",x$deviance,"\n ")
      cat("\nSmoothing Parameters:\n")
      print(c(lambda=x$lambda,x$gammas))
      cat("\n")
    } else {
      ehat=round(quantile(x$residuals),digits)
      names(ehat)=c("Min","1Q","Median","3Q","Max")
      cat("\nFamily:\n")
      cat(x$family,"\n")
      cat("\nCall:\n")
      print(x$call)
      cat("\nResiduals:\n")
      print(ehat)
      cat("\nDispersion Estimate:\n")
      cat(x$dispersion," on ",as.numeric(x$n-x$df)," degrees of freedom","\n")
      cat("\nFit Statistics:")
      cat("\nGCV:  ",x$info[1])
      cat("\nR^2:  ",x$info[2])
      cat("\nAIC:  ",x$info[3])
      cat("\nBIC:  ",x$info[4])
      cat("\nDev:  ",x$deviance,"\n ")
      cat("\nSmoothing Parameters:\n")
      print(c(lambda=x$lambda,x$gammas))
      cat("\n")
    }
    
  }