% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step3_rcv_d.R
\name{rcv_d}
\alias{rcv_d}
\title{Parameter and Model Recovery}
\usage{
rcv_d(
  data,
  id = 1,
  n_trials = 288,
  simulate_models = list(TD, RSTD, Utility),
  simulate_lower = list(c(0, 0), c(0, 0, 0), c(0, 0, 0)),
  simulate_upper = list(c(1, 1), c(1, 1, 1), c(1, 1, 1)),
  fit_models = list(TD, RSTD, Utility),
  fit_lower = list(c(0, 0), c(0, 0, 0), c(0, 0, 0)),
  fit_upper = list(c(1, 1), c(1, 1, 1), c(1, 1, 1)),
  model_names = c("TD", "RSTD", "Utility"),
  funcs = NULL,
  initial_params = NA,
  initial_size = 50,
  iteration_s = 10,
  iteration_f = 10,
  seed = 1,
  nc = 1,
  algorithm
)
}
\arguments{
\item{data}{[data.frame] raw data. 
This data should include the following mandatory columns: 
- "sub", "time_line", "L_choice", "R_choice", "L_reward", "R_reward".}

\item{id}{[vector] which subject is going to be analyzed.
is being analyzed. The value should correspond to an entry in the "sub" 
column, which must contain the subject IDs. 
e.g., `id = c(1:40)`}

\item{n_trials}{[integer] number of total trials}

\item{simulate_models}{[list] A collection of functions used to generate simulated data.}

\item{simulate_lower}{[list] The lower bounds for simulate models}

\item{simulate_upper}{[list] The upper bounds for simulate models}

\item{fit_models}{[list] A collection of functions applied to fit models to the data.}

\item{fit_lower}{[list] The lower bounds for model fit models}

\item{fit_upper}{[list] The upper bounds for model fit models}

\item{model_names}{[list] the names of fit modals}

\item{funcs}{[vector] A character vector containing the names of all 
user-defined functions required for the computation.}

\item{initial_params}{[vector] Initial values for the free parameters. 
These need to be set only when using L-BFGS-B. Other algorithms 
automatically generate initial values.
for `L-BFGS-B`, `GenSA`, set `initial = c(0, 0, ...)`}

\item{initial_size}{[integer] Initial values for the free parameters. 
These need to be set only when using L-BFGS-B. Other algorithms 
automatically generate initial values.
for `Bayesian`, `GA`, set `initial = 50`}

\item{iteration_s}{[integer] the number of iteration in simulation (simulate)}

\item{iteration_f}{[integer] the number of iteration in algorithm (fit)}

\item{seed}{[integer] random seed. This ensures that the results are 
reproducible and remain the same each time the function is run. 
default: `seed = 123`}

\item{nc}{[integer] Number of CPU cores to use for parallel computation.}

\item{algorithm}{[character] Choose a algorithm package from 
`L-BFGS-B`, `GenSA`, `GA`, `DEoptim`, `Bayesian`, `PSO`, `CMA-ES`}
}
\value{
a list containing all recovery data
}
\description{
This function fits multiple sets of simulated data using a loop.  
 You need to provide a list of simulation functions, fitting functions,  
 and parameter bounds. If you prefer to handle the process manually,  
 you can use the internal functions `simulate_list` and `recovery_data`.
 
 For more information, please refer to the GitHub repository:
 https://github.com/yuki-961004/binaryRL
}
