% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_recovery_data.R
\name{recovery_data}
\alias{recovery_data}
\title{Process: Recovering Fake Data}
\usage{
recovery_data(
  list,
  id = 1,
  fit_model,
  funcs = NULL,
  model_name,
  n_params,
  n_trials,
  lower,
  upper,
  initial_params = NA,
  initial_size = 50,
  iteration = 10,
  seed = 123,
  nc = 1,
  algorithm
)
}
\arguments{
\item{list}{[list] a list generated by function `simulate_list`}

\item{id}{[integer] default = 1}

\item{fit_model}{[function] fit model}

\item{funcs}{[vector] A character vector containing the names of all 
user-defined functions required for the computation.}

\item{model_name}{[character] the name of your modal}

\item{n_params}{[integer] The number of free parameters in your model.}

\item{n_trials}{[integer] The total number of trials in your experiment.}

\item{lower}{[vector] lower bounds of free parameters}

\item{upper}{[vector] upper bounds of free parameters}

\item{initial_params}{[vector] Initial values for the free parameters. 
These need to be set only when using L-BFGS-B. Other algorithms 
automatically generate initial values.
for `L-BFGS-B`, `GenSA`, set `initial = c(0, 0, ...)`}

\item{initial_size}{[integer] Initial values for the free parameters. 
These need to be set only when using L-BFGS-B. Other algorithms 
automatically generate initial values.
for `Bayesian`, `GA`, set `initial = 50`}

\item{iteration}{[integer] the number of iteration}

\item{seed}{[integer] random seed. This ensures that the results are 
reproducible and remain the same each time the function is run. 
default: `seed = 123`}

\item{nc}{[integer] Number of CPU cores to use for parallel computation.}

\item{algorithm}{[character] Choose an algorithm package from
`L-BFGS-B`, `GenSA`, `GA`, `DEoptim`, `PSO`, `Bayesian`, `CMA-ES`.
In addition, any algorithm from the `nloptr` package is also
supported. If your chosen `nloptr` algorithm requires a local search,
you need to input a character vector. The first element represents
the algorithm used for global search, and the second element represents
the algorithm used for local search.}
}
\value{
a data frame for parameter recovery and model recovery
}
\description{
This function applies `optimize_para` to each fake data in the list generated 
 by `simulate_list`. The results can be used for parameter recovery and 
 model recovery, helping evaluate the consistency and validity of the 
 reinforcement learning model.

 For more information, please refer to the GitHub repository:
 https://github.com/yuki-961004/binaryRL
}
