% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beam.R
\name{beam_distance}
\alias{beam_distance}
\title{Calculate radar beam distance}
\usage{
beam_distance(range, elev, k = 4/3, lat = 35, re = 6378, rp = 6357)
}
\arguments{
\item{range}{numeric. Slant range in m, the length of the skywave path
between target and the radar antenna.}

\item{elev}{numeric. Beam elevation in degrees.}

\item{k}{Standard refraction coefficient.}

\item{lat}{Geodetic latitude of the radar in degrees.}

\item{re}{Earth equatorial radius in km.}

\item{rp}{Earth polar radius in km.}
}
\value{
numeric. Beam distance (down range) in m.
}
\description{
Calculates the distance as measured over the earth's surface (the down range)
for a given beam elevation and slant range.
}
\details{
depends on \link{beam_height} to calculate beam height.
}
\examples{
# down range of the 5 degree elevation beam at a slant range of 100 km:
beam_distance(100000, 5)
}
