% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitMultipleDynamicGrowth_class.R
\name{FitMultipleDynamicGrowth}
\alias{FitMultipleDynamicGrowth}
\alias{print.FitMultipleDynamicGrowth}
\alias{plot.FitMultipleDynamicGrowth}
\alias{summary.FitMultipleDynamicGrowth}
\alias{residuals.FitMultipleDynamicGrowth}
\alias{coef.FitMultipleDynamicGrowth}
\alias{vcov.FitMultipleDynamicGrowth}
\alias{deviance.FitMultipleDynamicGrowth}
\alias{fitted.FitMultipleDynamicGrowth}
\alias{predict.FitMultipleDynamicGrowth}
\alias{logLik.FitMultipleDynamicGrowth}
\alias{AIC.FitMultipleDynamicGrowth}
\title{FitMultipleDynamicGrowth class}
\usage{
\method{print}{FitMultipleDynamicGrowth}(x, ...)

\method{plot}{FitMultipleDynamicGrowth}(
  x,
  y = NULL,
  ...,
  add_factor = NULL,
  ylims = NULL,
  label_x = "time",
  label_y1 = "logN",
  label_y2 = add_factor,
  line_col = "black",
  line_size = 1,
  line_type = "solid",
  line_col2 = "black",
  line_size2 = 1,
  line_type2 = "dashed",
  point_size = 3,
  point_shape = 16,
  subplot_labels = "AUTO"
)

\method{summary}{FitMultipleDynamicGrowth}(object, ...)

\method{residuals}{FitMultipleDynamicGrowth}(object, ...)

\method{coef}{FitMultipleDynamicGrowth}(object, ...)

\method{vcov}{FitMultipleDynamicGrowth}(object, ...)

\method{deviance}{FitMultipleDynamicGrowth}(object, ...)

\method{fitted}{FitMultipleDynamicGrowth}(object, ...)

\method{predict}{FitMultipleDynamicGrowth}(object, env_conditions, times = NULL, ...)

\method{logLik}{FitMultipleDynamicGrowth}(object, ...)

\method{AIC}{FitMultipleDynamicGrowth}(object, ..., k = 2)
}
\arguments{
\item{x}{an instance of FitMultipleDynamicGrowth.}

\item{...}{ignored}

\item{y}{ignored}

\item{add_factor}{whether to plot also one environmental factor.
If \code{NULL} (default), no environmental factor is plotted. If set
to one character string that matches one entry of x$env_conditions,
that condition is plotted in the secondary axis}

\item{ylims}{A two dimensional vector with the limits of the primary y-axis.}

\item{label_x}{label of the x-axis}

\item{label_y1}{Label of the primary y-axis.}

\item{label_y2}{Label of the secondary y-axis.}

\item{line_col}{Aesthetic parameter to change the colour of the line geom in the plot, see: \code{\link[=geom_line]{geom_line()}}}

\item{line_size}{Aesthetic parameter to change the thickness of the line geom in the plot, see: \code{\link[=geom_line]{geom_line()}}}

\item{line_type}{Aesthetic parameter to change the type of the line geom in the plot, takes numbers (1-6) or strings ("solid") see: \code{\link[=geom_line]{geom_line()}}}

\item{line_col2}{Same as lin_col, but for the environmental factor.}

\item{line_size2}{Same as line_size, but for the environmental factor.}

\item{line_type2}{Same as lin_type, but for the environmental factor.}

\item{point_size}{Size of the data points}

\item{point_shape}{shape of the data points}

\item{subplot_labels}{labels of the subplots according to \code{plot_grid}.}

\item{object}{an instance of FitMultipleDynamicGrowth}

\item{env_conditions}{a tibble describing the environmental conditions (as
in \code{\link[=fit_multiple_growth]{fit_multiple_growth()}}.}

\item{times}{A numeric vector with the time points for the simulations. \code{NULL}
by default (using the same time points as the ones defined in \code{env_conditions}).}

\item{k}{penalty for the parameters (k=2 by default)}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

The class \link{FitMultipleDynamicGrowth} has been superseded by the top-level
class \link{GlobalGrowthFit}, which provides a unified approach for growth modelling.

Still, it is still returned if the superseded \code{\link[=fit_multiple_growth]{fit_multiple_growth()}} is called.

It is a subclass of list with the items:
\itemize{
\item fit_results: the object returned by \code{modFit}.
\item best_prediction: a list with the models predictions for each condition.
\item data: a list with the data used for the fit.
\item starting: starting values for model fitting
\item known: parameter values set as known.
\item sec_models: a named vector with the secondary model
for each environmental factor.
}
}
\section{Functions}{
\itemize{
\item \code{print.FitMultipleDynamicGrowth}: print of the model

\item \code{plot.FitMultipleDynamicGrowth}: comparison between the fitted model and
the experimental data.

\item \code{summary.FitMultipleDynamicGrowth}: statistical summary of the fit.

\item \code{residuals.FitMultipleDynamicGrowth}: calculates the model residuals. Returns a
tibble with 4 columns: time (storage time), logN (observed count),
exp (name of the experiment) and res (residual).

\item \code{coef.FitMultipleDynamicGrowth}: vector of fitted parameters.

\item \code{vcov.FitMultipleDynamicGrowth}: (unscaled) variance-covariance matrix,
estimated as 1/(0.5*Hessian).

\item \code{deviance.FitMultipleDynamicGrowth}: deviance of the model.

\item \code{fitted.FitMultipleDynamicGrowth}: fitted values. They are returned as a
tibble with 3 columns: time (storage time), exp (experiment
identifier) and fitted (fitted value).

\item \code{predict.FitMultipleDynamicGrowth}: vector of model predictions

\item \code{logLik.FitMultipleDynamicGrowth}: loglikelihood of the model

\item \code{AIC.FitMultipleDynamicGrowth}: Akaike Information Criterion
}}

