% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_guesses.R
\name{show_guess_dynamic}
\alias{show_guess_dynamic}
\title{Plot of the initial guess for growth under dynamic environmental conditions}
\usage{
show_guess_dynamic(
  fit_data,
  model_keys,
  guess,
  env_conditions,
  logbase_mu = 10,
  formula = logN ~ time
)
}
\arguments{
\item{fit_data}{Tibble (or data.frame) of data for the fit. It must have two columns, one with
the elapsed time (\code{time} by default) and another one with the decimal logarithm
of the populatoin size (\code{logN} by default). Different column names can be
defined using the \code{formula} argument.}

\item{model_keys}{Named the equations of the secondary model as in \code{\link[=fit_growth]{fit_growth()}}}

\item{guess}{Named vector with the initial guess of the model parameters as in \code{\link[=fit_growth]{fit_growth()}}}

\item{env_conditions}{Tibble describing the variation of the environmental
conditions for dynamic experiments. See \code{\link[=fit_growth]{fit_growth()}}.}

\item{logbase_mu}{Base of the logarithm the growth rate is referred to.
By default, 10 (i.e. log10). See vignette about units for details.}

\item{formula}{an object of class "formula" describing the x and y variables.
\code{logN ~ time} as a default.}
}
\value{
A \code{\link[=ggplot]{ggplot()}} comparing the model prediction against the data
}
\description{
Compares the prediction corresponding to a guess of the parameters of the
model against experimental data
}
