% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/function_mapping.R
\name{check_model_params}
\alias{check_model_params}
\title{Correctness Check of Model Parameters}
\usage{
check_model_params(simulation_model, known_params, starting_points, adjust_vars)
}
\arguments{
\item{simulation_model}{character with a valid model key.}

\item{known_params}{named vector or list with the dof of the model
known.}

\item{starting_points}{named vector or list with the dof of the model to
be adjusted.}

\item{adjust_vars}{logical specifying whether the model variables need to
be included in the check (not used for isothermal
fit)}
}
\description{
Makes 3 checks of compatibility between the input parameters for the
adjustment and the DOF of the inactivation model selected.
\itemize{
     \item Check of equal length of model DOF and input DOF. Raises a
           warning if failed.
     \item Check that every single one of the input DOF is a model DOF.
           Raises a warning if failed.
     \item Check that every single one of the model DOF are defined as
           an input DOF.}
}

