% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/calculate_cost.R
\name{get_prediction_cost}
\alias{get_prediction_cost}
\title{Error of the Prediction of Microbial Inactivation}
\usage{
get_prediction_cost(data_for_fit, temp_profile, simulation_model, P,
  known_params)
}
\arguments{
\item{data_for_fit}{A data frame with the experimental data to fit. It
must contain a column named \dQuote{time} and another one named
\dQuote{N}.}

\item{temp_profile}{\code{data.frame} defining the temperature profile. It
must have a column named \dQuote{time} and another named
\dQuote{temperature}.}

\item{simulation_model}{character key defining the inactivation model.}

\item{P}{list with the unknown parameters of the model to be adjusted.}

\item{known_params}{list with the parameters of the model fixed (i.e.,
       not adjusted)}
}
\value{
An instance of \code{\link{modCost}} with the error of the
        prediction.
}
\description{
Calculates the error of the prediction of microbial inactivation for
the chosen inactivation model and the given parameters with respect to
the experimental data provided.
This function is compatible with the function
\code{\link{fit_dynamic_inactivation}}.
}
\seealso{
\code{\link{modCost}}, \code{\link{fit_dynamic_inactivation}}
}

