% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_MCMC.R
\name{sample_dynaFit}
\alias{sample_dynaFit}
\title{Random sample of the parameters of a FitInactivation object}
\usage{
sample_dynaFit(dynamic_fit, times, n_simulations)
}
\arguments{
\item{dynamic_fit}{An object of class \code{FitInactivationMCMC} as generated
by \code{\link{fit_inactivation_MCMC}}.}

\item{times}{numeric vector specifying the time points when results are
desired. If \code{NULL}, the times in \code{MCMC_fit$best_prediction}
are used.}

\item{n_simulations}{a numeric indicating how many Monte Carlo simulations
to perform.}
}
\value{
Returns a list with 4 components.
        \itemize{
             \item par_sample: data frame with the parameter sample.
             \item simulation_model: model key for the simulation
             \item known_pars: parameters of the model known
             \item times: points where the calculation is made.
             }
}
\description{
Function to be called by \code{\link{predict_inactivation_MCMC}}. Produces
a random sample of the parameters adjusted from dynamic experiments with non
linear regression.
}
\details{
It is assumed that the parameters follow a Multivariate Normal distribution
with the mean the parameters estimated by \code{\link{modFit}}. The unscaled
covariance matrix returned by \code{\link{modFit}} is used.

The function produces a random sample using the function \code{\link{mvrnorm}}.
}
