% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_template.R
\name{use_template}
\alias{use_template}
\title{Use biometryassist analysis templates}
\usage{
use_template(
  template_name = "mixed_model_template.R",
  dest_dir = ".",
  open = TRUE,
  overwrite = FALSE,
  output_name = NULL
)
}
\arguments{
\item{template_name}{Name or path of the template file to use.
Default is \code{"mixed_model_template.R"}. Available templates can be listed
with \code{list_templates()}.}

\item{dest_dir}{Directory where the template should be copied.
Default is the current working directory (\code{"."}).}

\item{open}{Logical (default \code{TRUE}). Should the template file be opened in the default
editor after copying?}

\item{overwrite}{Logical (default \code{FALSE}). Should existing files be overwritten?}

\item{output_name}{\code{character}, Optional. Name for the copied file in the destination directory.
If not specified, defaults to \code{"analysis_script.R"}.
If specified, the template will be copied and renamed to this file.
(The original template file is not overwritten.)}
}
\value{
The file path to the copied template (invisibly). Called primarily for
its side effects of copying and optionally opening the template file.
}
\description{
\code{use_template()} copies a pre-built analysis template from the biometryassist
package to your working directory and optionally opens it for editing. These
templates provide standardized approaches for common agronomic analyses.
}
\details{
This function is designed to help users get started with biometryassist
analyses by providing tested, documented templates. The templates include:
\itemize{
\item Suggested package loading
\item Commented code explaining steps
\item Example data exploration
\item Common analysis workflows
}

If a file with the same name already exists in the destination directory,
the function will not overwrite it unless \code{overwrite = TRUE} is specified.
In this case, it will still open the existing file if \code{open = TRUE}.
}
\examples{
\dontrun{
# Copy and open the default analysis template
use_template()

# Copy a specific template without opening
use_template("anova_template.R", open = FALSE)

# Copy to a specific directory
use_template("mixed_model_template.R", dest_dir = "analyses")

# Overwrite an existing file
use_template("mixed_model_template.R", overwrite = TRUE)
}

}
\seealso{
\itemize{
\item \code{\link[=list_templates]{list_templates()}} to see available templates
}
}
