% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imgPipe.R
\name{imgPipe}
\alias{imgPipe}
\title{Image analysis pipeline}
\usage{
imgPipe(
  img1 = img,
  color1 = "color1",
  img2 = NULL,
  color2 = "color2",
  img3 = NULL,
  color3 = "color3",
  alpha = 1,
  sigma = 2,
  sizeFilter = TRUE,
  upperlimit = "auto",
  lowerlimit = "auto",
  proximityFilter = TRUE,
  radius = "auto",
  parallel = FALSE
)
}
\arguments{
\item{img1}{image (import by \code{\link[imager]{load.image}})}

\item{color1}{name of color in img1}

\item{img2}{image (import by \code{\link[imager]{load.image}})}

\item{color2}{name of color in img2}

\item{img3}{image (import by \code{\link[imager]{load.image}})}

\item{color3}{name of color in img3}

\item{alpha}{threshold adjustment factor}

\item{sigma}{smoothing}

\item{sizeFilter}{applying sizeFilter function (default - TRUE)}

\item{upperlimit}{highest accepted object size (only needed if
sizeFilter = TRUE)}

\item{lowerlimit}{smallest accepted object size (when 'auto' both limits are
calculated by using the mean and the standard deviation)}

\item{proximityFilter}{applying proximityFilter function (default - TRUE)}

\item{radius}{distance from one center in which no other centers
are allowed (in pixels)}

\item{parallel}{if TRUE uses multiple cores (75 \%) to process results}
}
\value{
list of 3 to 4 objects:
\enumerate{
\item summary of all the microbeads in the image
\item detailed information about every single bead
\item (optional) result for every individual color
\item unfiltered coordinates of img1
}
}
\description{
This function serves as a pipeline that integrates tools for complete
start-to-finish image analysis. It enables the handling of images from
different channels, including the analysis of dual-color microbeads. This
approach simplifies the workflow, providing a straightforward method to
analyze complex image data.
}
\examples{
result <- imgPipe(beads,
  alpha = 1, sigma = 2, upperlimit = 150,
  lowerlimit = 50
  )
plot(beads)
with(
  result$detailed,
  points(
    result$detailed$x,
    result$detailed$y,
    col = "darkgreen",
    pch = 19
    )
  )
}
