% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat_to_net.R
\name{mat_to_net}
\alias{mat_to_net}
\title{Create a data.frame from a contingency table}
\usage{
mat_to_net(
  mat,
  weight = FALSE,
  remove_zeroes = TRUE,
  include_diag = TRUE,
  include_lower = TRUE
)
}
\arguments{
\item{mat}{a contingency table (i.e. \code{matrix}).}

\item{weight}{a \code{boolean} indicating if the value are weights.}

\item{remove_zeroes}{a \code{boolean} determining whether interactions with
weight equal to 0 should be removed from the output.}

\item{include_diag}{a \code{boolean} indicating whether the diagonal
should be included in the output. Only for squared matrix.}

\item{include_lower}{a \code{boolean} indicating whether the lower triangular
matrix should be included in the output. Only for squared matrix.}
}
\value{
A \code{data.frame} where each row represents the interaction
between two nodes and an optional third column indicating the weight of the
interaction.
}
\description{
This function creates a two- or three-columns \code{data.frame} where
each row represents the interaction between two nodes (site and species for
example) and an optional third column indicating the weight of the
interaction (if \code{weight = TRUE}) from a contingency table (sites as
rows and species as columns for example).
}
\examples{
mat <- matrix(sample(1000, 50), 5, 10)
rownames(mat) <- paste0("Site", 1:5)
colnames(mat) <- paste0("Species", 1:10)

net <- mat_to_net(mat, weight = TRUE)

}
\seealso{
\link{net_to_mat}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}),
Pierre Denelle (\email{pierre.denelle@gmail.com}) and
Boris Leroy (\email{leroy.boris@gmail.com})
}
