% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp_data.R
\name{plot.birp_data}
\alias{plot.birp_data}
\title{Plot a birp_data Object}
\usage{
\method{plot}{birp_data}(
  x,
  col = 1:length(x$locations),
  lwd = 1,
  lty = 1:length(x$method_names),
  pch = 1:length(x$CI_groups),
  xlab = "time",
  ylab = "counts per unit of effort",
  legend.x = "topright",
  legend.y = NULL,
  legend.bty = "o",
  xlim = range(as.numeric(x$times)),
  ylim = NA,
  ...
)
}
\arguments{
\item{x}{A \code{birp_data} object to be plotted.}

\item{col}{A vector of colors, recycled to match the number of locations.}

\item{lwd}{A vector of line widths, recycled to match the number of method-location combinations.}

\item{lty}{A vector of line types, recycled to match the number of methods.}

\item{pch}{A vector of plotting characters, recycled to match the number of control-intervention (CI) groups.}

\item{xlab}{Label for the x-axis.}

\item{ylab}{Label for the y-axis.}

\item{legend.x}{The x-position for the legend. Use \code{NA} to omit the legend.}

\item{legend.y}{The y-position for the legend.}

\item{legend.bty}{Box type for the legend; either \code{"o"} (default) or \code{"n"}.}

\item{xlim}{Numeric vector specifying the x-axis limits.}

\item{ylim}{Numeric vector specifying the y-axis limits. If \code{NA}, limits are computed automatically.}

\item{...}{Additional graphical parameters passed to \code{plot()} or \code{lines()}.}
}
\value{
No return value. Called for side effects.
}
\description{
This function plots observed counts per unit of effort over time, for each method-location combination in a \code{birp_data} object.
}
\examples{
data <- simulate_birp()
plot(data)
}
