% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_bucket_trades.R
\name{map_bucket_trades}
\alias{map_bucket_trades}
\title{Bucket trade data over an extended period}
\usage{
map_bucket_trades(
  start_date = "2015-09-25 13:00:00",
  end_date = now(tzone = "UTC"),
  binSize = "1d",
  symbol = "XBTUSD",
  partial = "false",
  filter = NULL,
  use_auth = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{start_date}{character string.
Starting date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{end_date}{character string.
Ending date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{binSize}{character string.
The time interval to bucket by, must be one of: \code{"1m"}, \code{"5m"}, \code{"1h"} or \code{"1d"}.}

\item{symbol}{a character string for the instrument symbol.
Use \code{\link[=available_symbols]{available_symbols()}} to see available symbols.}

\item{partial}{character string. Either \code{"true"} or \code{"false"}.
If \code{"true"}, will send in-progress (incomplete) bins for the current time period.}

\item{filter}{an optional character string for table filtering.
Send JSON key/value pairs, such as \code{"{'key':'value'}"}. See examples in \code{\link[=trades]{trades()}}.}

\item{use_auth}{logical. Use \code{TRUE} to enable authentication with API key.}

\item{verbose}{logical. If \code{TRUE}, will print information to the console. Useful for
long running requests.}
}
\value{
\code{map_bucket_trades} returns a \code{data.frame} containing:
\itemize{
\item{timestamp: }{POSIXct. Date and time of trade.}
\item{symbol: }{character. Instrument ticker.}
\item{open: }{numeric. Opening price for the bucket.}
\item{high: }{numeric. Highest price in the bucket.}
\item{low: }{numeric. Lowest price in the bucket.}
\item{close: }{numeric. Closing price of the bucket.}
\item{trades: }{numeric. Number of trades executed within the bucket.}
\item{volume: }{numeric. Volume in USD.}
\item{vwap: }{numeric. Volume weighted average price.}
\item{lastSize: }{numeric. Size of the last trade executed.}
\item{turnover: }{numeric. How many satoshi were exchanged.}
\item{homeNotional: }{numeric. BTC value of the bucket.}
\item{foreignNotional: }{numeric. USD value of the bucket.}
}
}
\description{
\code{map_bucket_trades()} uses \code{purrr::map_dfr} to execute multiple API calls.
This is useful when the data you want to return exceeds the maximum 1000 row response limit,
but do not want to have to manually call \code{\link[=bucket_trades]{bucket_trades()}} repeatedly.
}
\details{
\code{map_bucket_trades()} takes a start and end date, and creates a sequence of start dates
which are passed in to the `startTime`` parameter in \code{\link[=bucket_trades]{bucket_trades()}}.

The length of time between each start time in each API call is determined by the binSize.
For example, \code{"1d"} is chosen as the binSize the length of time between start dates will be 1000 days.
If \code{"1h"} is chosen, it will be 1000 hours etc.

The function will print the number of API calls being sent and provides a progress bar in the console

Public API requests are limited to 30 per minute. Consequently, \code{map_bucket_trades()} uses
\code{purrr::slowly} to restrict how often the function is called.
}
\examples{
\donttest{
# Get hourly bucketed trade data between 2020-01-01 and 2020-02-01

map_bucket_trades(
  start_date = "2020-01-01",
  end_date = "2020-02-01",
  binSize = "1h"
)
}

}
\references{
\url{https://www.bitmex.com/api/explorer/#!/Trade/Trade_getBucketed}
}
\concept{bucket_trades}
