% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_text.R
\name{block_text}
\alias{block_text}
\title{A block of text}
\usage{
block_text(text)
}
\arguments{
\item{text}{Plain text or Markdown text (via \code{\link[=md]{md()}}).}
}
\description{
With \code{block_text()} we can define a text area and this can be easily combined
with other \code{block_*()} functions. The text will take the entire width of the
block and will resize according to screen width. Like all \code{block_*()}
functions, \code{block_text()} must be placed inside of \code{blocks()} and the
resultant \code{blocks} object can be provided to the \code{body}, \code{header}, or
\code{footer} arguments of \code{compose_email()}.
}
\examples{
# Create a block of two, side-by-side
# articles with two `article()` calls
# inside of `block_articles()`, itself
# placed in `blocks()`; also, include some
# text at the top with `block_text()`
email <-
  compose_email(
    body =
      blocks(
        block_text(
          "These are two of the cities I visited this year.
          I liked them a lot, so, I'll visit them again!"),
        block_articles(
          article(
            image = "https://i.imgur.com/dig0HQ2.jpg",
            title = "Los Angeles",
            content =
              "I want to live in Los Angeles.
              Not the one in Los Angeles.
              No, not the one in South California.
              They got one in South Patagonia."
          ),
          article(
            image = "https://i.imgur.com/RUvqHV8.jpg",
            title = "New York",
            content =
              "Start spreading the news.
              I'm leaving today.
              I want to be a part of it.
              New York, New York."
          )
        )
      )
    )

if (interactive()) email

}
