% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{n_dist}
\alias{n_dist}
\title{Distribution of the Sample Size}
\usage{
n_dist(design, n1, nuisance, summary = TRUE, plot = FALSE, ...)
}
\arguments{
\item{design}{object of class \code{TestStatistc} created by \code{setup}}

\item{n1}{number of patients that are recruited before the sample size
is recalculated}

\item{nuisance}{nuisance parameter that is estimated at the interim analysis}

\item{summary}{logical - is a summary of the sample size distribution desired?
Otherwise, a vector with sample sizes is returned.}

\item{plot}{Should a plot of the sample size distribution
be drawn?}

\item{...}{Further optional arguments.}
}
\value{
Summary and/or plot of the sample size distribution for
  every nuisance parameter and every value of n1.
}
\description{
Calculates the distribution of the total sample sizes of designs
with blinded sample size recalculation for different values of the
nuisance parameter or of n1.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.

The method is implemented for the classes \code{\link{Student}},
\code{\link{ChiSquare}}, and \code{\link{FarringtonManning}}.
}
\examples{
d <- setupStudent(alpha = .025, beta = .2, r = 1, delta = 3.5, delta_NI = 0,
                  alternative = "greater", n_max = 156)
n_dist(d, n1 = 20, nuisance = 5.5, summary = TRUE, plot = FALSE, seed = 2020)


}
