% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Student.R
\name{n_dist,Student-method}
\alias{n_dist,Student-method}
\title{Distribution of the Sample Size}
\usage{
\S4method{n_dist}{Student}(
  design,
  n1,
  nuisance,
  summary = TRUE,
  plot = FALSE,
  iters = 10000,
  seed = NULL,
  range = 0,
  allocation = c("approximate", "exact"),
  ...
)
}
\arguments{
\item{design}{Object of class \code{Student} created by \code{setupStudent}.}

\item{n1}{Either the sample size of the first stage (if
\code{recalculation = TRUE} or the toal sample size (if
\code{recalculation = FALSE}).}

\item{nuisance}{Value of the nuisance parameter. For the
Student's t-test this is the variance.}

\item{summary}{Is a summary of the sample size distribution desired?
Otherwise, a vector with sample sizes is returned.}

\item{plot}{Should a plot of the sample size distribution be drawn?}

\item{iters}{Number of simulation iterations.}

\item{seed}{Random seed for simulation.}

\item{range}{this determines how far the plot whiskers extend out from the box.
If range is positive, the whiskers extend to the most extreme data point
which is no more than range times the interquartile range from the box.
A value of zero causes the whiskers to extend to the data extremes.}

\item{allocation}{Whether the allocation ratio should be preserved
exactly (\code{exact}) or approximately (\code{approximate}).}

\item{...}{Further optional arguments.}
}
\value{
Summary and/or plot of the sample size distribution for
  every nuisance parameter and every value of n1.
}
\description{
Calculates the distribution of the total sample sizes of designs
with blinded sample size recalculation for different values of the
nuisance parameter or of n1.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.
}
\examples{
d <- setupStudent(alpha = .025, beta = .2, r = 1, delta = 3.5, delta_NI = 0,
                  alternative = "greater", n_max = 156)
n_dist(d, n1 = 20, nuisance = 5.5, summary = TRUE, plot = FALSE, seed = 2020)

}
