% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.R
\name{vb_discrete}
\alias{vb_discrete}
\title{Discrete voting bloc analysis}
\usage{
vb_discrete(
  data,
  data_density = data,
  data_turnout = data,
  data_vote = data,
  indep,
  dv_vote3,
  dv_turnout,
  weight = NULL,
  boot_iters = FALSE,
  verbose = FALSE,
  check_discrete = TRUE
)
}
\arguments{
\item{data}{default data.frame to use as the source for
density, turnout, and vote choice data.}

\item{data_density}{data.frame of blocs' composition/density data. Must
include any columns named by \code{indep} and \code{weight}.}

\item{data_turnout}{data.frame of blocs' turnout data. Must include any
columns named by \code{dv_turnout}, \code{indep} and
\code{weight}.}

\item{data_vote}{data.frame of blocs' vote choice data. Must include any
columns named by \code{dv_vote3}, \code{indep}, and \code{weight}.}

\item{indep}{string, column name of the independent variable defining
discrete voting blocs.}

\item{dv_vote3}{string, column name of the dependent variable in \code{data_vote}, coded as
follows: -1 for Democrat vote choice, 0 for no or third-party vote, 1 for
Republican vote choice.}

\item{dv_turnout}{string, column name of the dependent variable flagging
voter turnout in \code{data_turnout}. That column must be coded 0 =  no vote, 1 = voted.}

\item{weight}{optional string naming the column of sample weights.}

\item{boot_iters}{integer, number of bootstrap iterations for uncertainty
estimation. The default \code{FALSE} is equivalent to 0 and does not estimate
uncertainty.}

\item{verbose}{logical, whether to print iteration number.}

\item{check_discrete}{logical, whether to check if \code{indep} is a discrete variable.}
}
\value{
A \code{vbdf} object.
}
\description{
Define voting blocs along a \strong{discrete} variable and estimate their partisan
vote contributions.
}
