\name{posterior.plot}
\alias{posterior.plot}
\title{
Posterior distribution plots for summary estimates and between-study standard 
deviation (measurement of heterogeneity)
}
\description{
Function to create posterior distribution plots for summary estimates and 
between-study standard deviation based on output from \code{bmeta}
}
\usage{
posterior.plot(x, xlim = NULL, xlab="", main="Posterior distribution Plot", 
scale = "log",heterogeneity=FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
a \code{bmeta} object with results of the model
}
  \item{xlim}{
horozontal limits of the plot region. If unspecified, the function sets the horizontal 
plot limits to (-3,3) for binary and count data and (-5,5) for continuous data.
}
  \item{xlab}{
title for the x-axis
}
  \item{main}{
title of the plot. If unspecified, the function sets an appropriate title by default.
}
  \item{scale}{
logical specifying whether summary estimates need to be displayed on log ("log") or 
natural scale ("exp"). For continuous data, summary estimates are always displayed on 
natural scale, therefore, users do not need to specify this option. 
}
  \item{heterogeneity}{
logical specifying whether to resent posterior plot for between-study standard 
deviation (TRUE) to examine heterogeneity of different studies. If unspecified, FALSE 
by default.
}
}
\references{
Anzures-Cabrera,J & Higgins,J.P.T.(2010) Graphical displays for meta-analysis: An 
overview with suggestions for practice.Res Synth Methods,1,66-80.
}
\author{
Tao Ding
Gianluca Baio
}
\examples{
### Read and format the data (binary)
data = read.csv(url("http://www.statistica.it/gianluca/bmeta/Data-bin.csv"))

### List data for binary outcome 
data.list <- list(y0=data$y0,y1=data$y1,n0=data$n0,n1=data$n1)

### Select random-effects meta-analysis with t-distribution prior for binary
### data
x <- bmeta(data.list, outcome="bin", model="std.dt", type="ran")

### using output from bmeta to produce posterior plot
posterior.plot(x)

### using output from bmeta and specify the horizontal limits 
posterior.plot(x,xlim=c(-2,1))

### using output from bmeta on natural scale and specify more options 
posterior.plot(x,xlim=c(-0.5,2.5),xlab="odds ratio",main="Posterior distribution
of pooled odds ratio", scale="exp")

### examine heterogeneity by producing posterior plot for between-study standard
### deviation
posterior.plot(x,heterogeneity=TRUE,xlim=c(0,3),xlab="between-study standard 
deviation")

}
\keyword{Bayesian meta-analysis}
