% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gera.bn.param.R
\name{gera.bn.param}
\alias{gera.bn.param}
\title{Learn the Bayesian Network Parameters from a Bayesian Network structure}
\usage{
gera.bn.param(bn.structure, data.to.work, param.name)
}
\arguments{
\item{bn.structure}{is a Bayesian Networks structure learned from data.}

\item{data.to.work}{is a data frame containing the variables of the Bayesian Networks learned.}

\item{param.name}{is a name of text file to be saved with parameters of BN.}
}
\value{
A set of parameters learned
}
\description{
Receives a Bayesian Network (BN) structure, a dataset and learn the parameters of BN.
}
\details{
This funcion receives a Bayesian Networks structure and a dataset, then learn the parameters 
of each node connection with 'bn.fit' function of bnlearn package. Finally it exports the 
Bayesian Networks parameters as a text file and return this same object.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
library(bnlearn)
# load datasets from package
data.to.work<-dataQuantC
# Set the name of a text to save the Bayesian Networks parameters
param.name <- "docbnparamHC.txt"
# Learn a Bayesian Networks structure from data
bn.structure <- hc(data.to.work)
# Generates a Bayesian Networks parameters from the Bayesian Networks structure and 
# write a text file with this
bn.param <- gera.bn.param(bn.structure, data.to.work, param.name)
}
\author{
Elias Carvalho
}

