##
## Example of 'var.rb=TRUE' parameter as a measure of the quality of the biplot - 2d
##

library(bpca)
## Differences between methods of factorization
# SQRT
bp1 <- bpca(gabriel1971, meth='sqrt', var.rb=TRUE)
qbp1 <- qbpca(gabriel1971, bp1)
plot(qbp1, main='sqrt - 2d \n (poor)')

# JK
bp2 <- bpca(gabriel1971, meth='jk', var.rb=TRUE)
qbp2 <- qbpca(gabriel1971, bp2)
plot(qbp2, main='jk - 2d \n (very poor)')

# GH
bp3 <- bpca(gabriel1971, meth='gh', var.rb=TRUE)
qbp3 <- qbpca(gabriel1971, bp3)
plot(qbp3, main='gh - 2d \n (good)')

# HJ
bp4 <- bpca(gabriel1971, meth='hj', lambda.end=2, var.rb=TRUE)
qbp4 <- qbpca(gabriel1971,  bp4)
plot(qbp4, main='hj - 2d \n (good)')
