% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{fit.bpnme}
\alias{fit.bpnme}
\title{Model fit for a Bayesian circular mixed-effects model}
\usage{
\method{fit}{bpnme}(object)
}
\arguments{
\item{object}{a \code{bpnme object} obtained from the function
\code{\link{bpnme}}.}
}
\value{
a matrix containing the computed log pointwise predictive density
  (lppd), Deviance Information Criterion (DIC), an alternative version of the
  DIC (DIC_alt), and the Watanabe-Akaike Information Criterion computed in
  two different ways (WAIC, WAIC2). The matrix also contains the number of
  parameters or 'effective number' of parameters that the several statistics
  are based on. Computation of the criteria is done according to Gelman et.al
  (2014) in *Bayesian Data Analysis*.
}
\description{
Outputs several model fit statistics for the Bayesian circular mixed-effects
model
}
\examples{
library(bpnreg)
fit.Maps <- bpnme(pred.I = Error.rad ~ Maze + Trial.type + L.c + (1|Subject),
data = Maps,
its = 100, burn = 1, n.lag = 1)
fit(fit.Maps)

}
