% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRII.R
\name{traceplot_or2}
\alias{traceplot_or2}
\title{Trace Plots for Ordinal Model with 3 outcomes}
\usage{
traceplot_or2(beta, sigma, burn)
}
\arguments{
\item{beta}{Gibbs draw of \eqn{\beta} vector of dimension \eqn{(k x nsim)}.}

\item{sigma}{Gibbs draw of scale parameter, \eqn{\sigma}.}

\item{burn}{number of discarded MCMC iterations.}
}
\value{
Returns trace plots for each element of \eqn{\beta} and \eqn{\sigma}.
}
\description{
This function generates trace plots of
MCMC samples for \eqn{(\beta ,\sigma)} in the quantile
regression model with 3 outcomes.
}
\details{
Trace plot is a visual depiction of the values generated from the Markov chain
versus the iteration number.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
k <- dim(x)[2]
output <- quantreg_or2(y = y,x = x, B0 = 10*diag(k),
mcmc = 50, p = 0.25)
mcmc <- 50
beta <- output$beta
sigma <- output$sigma
traceplot_or2(beta, sigma, round(0.25*mcmc))

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.
}
\seealso{
traces in MCMC simulations
}
