% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{covEffectOR1}
\alias{covEffectOR1}
\title{Covariate effect for OR1 model}
\usage{
covEffectOR1(modelOR1, y, xMat1, xMat2, p, verbose)
}
\arguments{
\item{modelOR1}{output from the quantregOR1 function.}

\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{xMat1}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.
If the covariate of interest is continuous, then the column for the covariate of interest remains unchanged (xMat1 = x).
If it is an indicator variable then replace the column for the covariate of interest with a
column of zeros.}

\item{xMat2}{matrix x with suitable modification to an independent variable including a column of ones with
or without column names. If the covariate of interest is continuous, then add the incremental change
to each observation in the column for the covariate of interest. If the covariate is an indicator variable,
then replace the column for the covariate of interest with a column of ones.}

\item{p}{quantile level or skewness parameter, p in (0,1).}

\item{verbose}{whether to print the final output and provide additional information or not, default is TRUE.}
}
\value{
Returns a list with components:
\itemize{
\item{\code{avgDiffProb}: }{vector with change in predicted
probabilities for each outcome category.}
}
}
\description{
This function computes the average covariate effect for different
outcomes of the OR1 model at a specified quantile. The covariate
effects are calculated marginally of the parameters and the remaining covariates.
}
\details{
This function computes the average covariate effect for different
outcomes of the OR1 model at a specified quantile. The covariate
effects are computed marginally of the parameters and the remaining covariates,
and utilizes draws from MCMC sampling.
}
\examples{
set.seed(101)
data("data25j4")
y <- data25j4$y
xMat1 <- data25j4$x
k <- dim(xMat1)[2]
J <- dim(as.array(unique(y)))[1]
b0 <- array(rep(0, k), dim = c(k, 1))
B0 <- 10*diag(k)
d0 <- array(0, dim = c(J-2, 1))
D0 <- 0.25*diag(J - 2)
modelOR1 <- quantregOR1(y = y, x = xMat1, b0, B0, d0, D0,
burn = 10, mcmc = 40, p = 0.25, tune = 1, verbose = FALSE)
xMat2 <- xMat1
xMat2[,3] <- xMat2[,3] + 0.02
res <- covEffectOR1(modelOR1, y, xMat1, xMat2, p = 0.25, verbose = TRUE)

# Summary of Covariate Effect:

#               Covariate Effect
# Category_1          -0.0076
# Category_2          -0.0014
# Category_3          -0.0010
# Category_4           0.0100

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). “Fitting and Comparison of Models
for Multivariate Ordinal Outcomes.” Advances in Econometrics: Bayesian Econometrics,
23: 115–156. DOI: 10.1016/S0731-9053(08)23004-5

Jeliazkov, I. and Rahman, M. A. (2012). “Binary and Ordinal Data Analysis
in Economics: Modeling and Estimation” in Mathematical Modeling with Multidisciplinary
Applications, edited by X.S. Yang, 123-150. John Wiley & Sons Inc, Hoboken, New Jersey. DOI: 10.1002/9781118462706.ch6
}
