% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{rndald}
\alias{rndald}
\title{Generates random numbers from an AL distribution}
\usage{
rndald(sigma, p, n)
}
\arguments{
\item{sigma}{scale factor, a scalar value.}

\item{p}{quantile or skewness parameter, p in (0,1).}

\item{n}{number of observations}
}
\value{
Returns a vector \eqn{(n x 1)} of random numbers from an AL(0, \eqn{\sigma}, p)
}
\description{
This function generates a vector of random numbers from an AL
distribution at quantile p.
}
\details{
Generates a vector of random numbers from an AL distribution
as a mixture of normal`–`exponential distributions.
}
\examples{
set.seed(101)
sigma <- 2.503306
p <- 0.25
n <- 1
output <- rndald(sigma, p, n)

# output
#   1.07328

}
\references{
Kozumi, H., and Kobayashi, G. (2011). `"Gibbs Sampling Methods for Bayesian Quantile Regression."`
Journal of Statistical Computation and Simulation, 81(11): 1565`-`1578. DOI: 10.1080/00949655.2010.496117

Yu, K., and Zhang, J. (2005). `"A Three-Parameter Asymmetric Laplace Distribution."`
Communications in Statistics - Theory and Methods, 34(9-10), 1867`-`1879. DOI: 10.1080/03610920500199018
}
\seealso{
asymmetric Laplace distribution
}
