% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/s3.generics.R
\name{hypothesis}
\alias{hypothesis}
\alias{hypothesis.brmsfit}
\title{Non-linear hypothesis testing}
\usage{
hypothesis(x, hypothesis, class = "b", alpha = 0.05, ...)
}
\arguments{
\item{x}{An \code{R} object typically of class \code{brmsfit}}

\item{hypothesis}{A character vector specifying one or more non-linear hypothesis concerning parameters of the model}

\item{class}{A string specifying the class of parameters being tested. Default is "b" for fixed effects.
Other typical options are "sd" or "cor". If \code{class = NULL}, all parameters can be tested
against each other, but have to be specified with their full name (see also \code{\link[brms:par.names]{par.names}})}

\item{alpha}{the alpha-level of the tests (default is 0.05)}

\item{...}{Currently ignored}
}
\value{
Summary statistics of the posterior distributions related to the hypotheses.
}
\description{
Perform non-linear hypothesis testing of fixed effects parameters
}
\details{
Among others, \code{hypothesis} calculates an evidence ratio for each hypothesis.
  For a directed hypothesis, this is just the posterior probability under the hypothesis against its alternative.
  For an undirected (i.e. point) hypothesis the evidence ratio is a Bayes factor between the hypothesis and its alternative.
  In order to calculate this Bayes factor, all parameters related to the hypothesis must have proper priors
  and argument \code{sample.priors} of function \code{brm} must be set to \code{TRUE}.
}
\examples{
\dontrun{
fit_i <- brm(rating ~ treat + period + carry + (1+treat|subject),
             data = inhaler, family = "gaussian")

hypothesis(fit_i, "treat = period + carry")
hypothesis(fit_i, "exp(treat) - 3 = 0")

## perform one-sided hypothesis testing
hypothesis(fit_i, "period + carry - 3 < 0")

# compare random effects standard deviations
hypothesis(fit_i, "treat < Intercept", class = "sd_subject")

## test more than one hypothesis at once
hypothesis(fit_i, c("treat = period + carry", "exp(treat) - 3 = 0"))
}
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

