% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{pp_check.brmsfit}
\alias{pp_check.brmsfit}
\alias{pp_check}
\title{Posterior Predictive Checks for \code{brmsfit} Objects}
\usage{
\method{pp_check}{brmsfit}(object, type, nsamples, group = NULL, x = NULL,
  newdata = NULL, re_formula = NULL, allow_new_levels = FALSE,
  sample_new_levels = "uncertainty", incl_autocor = TRUE, subset = NULL,
  ntrys = 5, loo_args = list(), ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{type}{Type of the ppc plot as given by a character string.
See \code{\link[bayesplot:PPC-overview]{PPC}} for an overview
of currently supported types. You may also use an invalid
type (e.g. \code{type = "xyz"}) to get a list of supported 
types in the resulting error message.}

\item{nsamples}{Positive integer indicating how many
posterior samples should be used.
If \code{NULL} all samples are used. If not specified,
the number of posterior samples is chosen automatically.
Ignored if \code{subset} is not \code{NULL}.}

\item{group}{Optional name of a factor variable in the model
by which to stratify the ppc plot. This argument is required for
ppc \code{*_grouped} types and ignored otherwise.}

\item{x}{Optional name of a variable in the model. 
Only used for ppc types having an \code{x} argument 
and ignored otherwise.}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the orginal data of the model is used.}

\item{re_formula}{formula containing group-level effects 
to be considered in the prediction. 
If \code{NULL} (default), include all group-level effects; 
if \code{NA}, include no group-level effects.}

\item{allow_new_levels}{A flag indicating if new
levels of group-level effects are allowed 
(defaults to \code{FALSE}). 
Only relevant if \code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels 
for grouping factors specified in \code{re_formula}.
This argument is only relevant if \code{newdata} is provided and 
\code{allow_new_levels} is set to \code{TRUE}.
If \code{"uncertainty"} (default), include group-level uncertainty
in the predictions based on the variation of the existing levels. 
If \code{"gaussian"}, sample new levels from the (multivariate) 
normal distribution implied by the group-level standard deviations 
and correlations. This options may be useful for conducting 
Bayesian power analysis. 
If \code{"old_levels"}, directly sample new levels from the
existing levels.}

\item{incl_autocor}{A flag indicating if autocorrelation
parameters should be included in the predictions. 
Defaults to \code{TRUE}.}

\item{subset}{A numeric vector specifying
the posterior samples to be used. 
If \code{NULL} (the default), all samples are used.}

\item{ntrys}{Parameter used in rejection sampling
for truncated discrete models only
(defaults to \code{5}). For more details see
\code{\link[brms:predict.brmsfit]{predict.brmsfit}}.}

\item{loo_args}{An optional list of additional arguments 
passed to \code{\link[loo:psislw]{psislw}}. 
Ignored for non \code{loo_*} ppc types.}

\item{...}{Further arguments passed to the ppc functions
of \pkg{\link[bayesplot:bayesplot]{bayesplot}}.}
}
\value{
A ggplot object that can be further
 customized using the \pkg{ggplot2} package.
}
\description{
Perform posterior predictive checks with the help
of the \pkg{bayesplot} package.
}
\details{
For a detailed explanation of each of the ppc functions, 
see the \code{\link[bayesplot:PPC-overview]{PPC}} 
documentation of the \pkg{\link[bayesplot:bayesplot]{bayesplot}} 
package.
}
\examples{
\dontrun{
fit <-  brm(count ~ log_Age_c + log_Base4_c * Trt_c
            + (1|patient) + (1|obs),
            data = epilepsy, family = poisson())

pp_check(fit)  # shows dens_overlay plot by default
pp_check(fit, type = "error_hist", nsamples = 11)
pp_check(fit, type = "scatter_avg", nsamples = 100)
pp_check(fit, type = "stat_2d")
pp_check(fit, type = "rootogram")
pp_check(fit, type = "loo_pit")

## get an overview of all valid types
pp_check(fit, type = "xyz")
}

}
