% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brocolors.R
\name{brocolors}
\alias{brocolors}
\title{Vectors of colors for figures}
\usage{
brocolors(set = c("general", "general2", "bg", "bgpng", "CC", "CCalt", "f2",
  "sex", "main", "crayons", "web"))
}
\arguments{
\item{set}{Character string indicating a set of colors.}
}
\value{
Vector of character strings representing the chosen set of colors, in RGB.
}
\description{
Creates different vectors of related colors that may be useful for figures.
}
\examples{
par(mar=c(0.6,5.1,0.6,0.6))
plot(0, 0, type="n", xlab="", ylab="", xlim=c(0, 9), ylim=c(8.5, 0), yaxs="i",
     xaxt="n", yaxt="n", xaxs="i")
axis(side=2, at=1:8, c("general", "general2", "bg", "bgpng", "CC", "f2", "sex", "main"), las=1)

gen <- brocolors("general")
points(seq(along=gen), rep(1,length(gen)), pch=21, bg=gen, cex=4)
text(seq(along=gen), rep(c(0.55, 0.7), length(gen))[seq(along=gen)], names(gen))

gen2 <- brocolors("general2")
points(seq(along=gen2), rep(2,length(gen2)), pch=21, bg=gen2, cex=4)
text(seq(along=gen2), rep(1+c(0.55, 0.7), length(gen2))[seq(along=gen2)], names(gen2))

points(1, 3, pch=21, bg=brocolors("bg"), cex=4)
points(1, 4, pch=21, bg=brocolors("bgpng"), cex=4)

CC <- brocolors("CC")
points(seq(along=CC), rep(5,length(CC)), pch=21, bg=CC, cex=4)
text(seq(along=CC), rep(4+c(0.55, 0.7), length(CC))[seq(along=CC)], names(CC))

f2 <- brocolors("f2")
points(seq(along=f2), rep(6,length(f2)), pch=21, bg=f2, cex=4)
text(seq(along=f2), rep(5.7, length(f2)), names(f2))

sex <- brocolors("sex")
points(seq(along=sex), rep(7,length(sex)), pch=21, bg=sex, cex=4)
text(seq(along=sex), rep(6.7, length(sex)), names(sex))

points(1, 8, pch=21, bg=brocolors("main"), cex=4)
}
\seealso{
\code{\link{plot_crayons}}
}
\keyword{utilities}

