% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/loess_tidiers.R
\name{loess_tidiers}
\alias{augment.loess}
\alias{loess_tidiers}
\title{Augmenting methods for loess models}
\usage{
\method{augment}{loess}(x, data = stats::model.frame(x), newdata, ...)
}
\arguments{
\item{x}{A "loess" object}

\item{data}{Original data, defaults to the extracting it from the model}

\item{newdata}{If provided, performs predictions on the new data}

\item{...}{extra arguments}
}
\value{
When \code{newdata} is not supplied \code{augment.loess}
returns one row for each observation with three columns added
to the original data:
   \item{.fitted}{Fitted values of model}
   \item{.se.fit}{Standard errors of the fitted values}
   \item{.resid}{Residuals of the fitted values}

When \code{newdata} is supplied \code{augment.loess} returns
   one row for each observation with one additional column:
   \item{.fitted}{Fitted values of model}
   \item{.se.fit}{Standard errors of the fitted values}
}
\description{
This method augments the original data with information
on the fitted values and residuals, and optionally the
standard errors.
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\examples{
lo <- loess(mpg ~ wt, mtcars)
augment(lo)

# with all columns of original data
augment(lo, mtcars)

# with a new dataset
augment(lo, newdata = head(mtcars))
}
\seealso{
\link{na.action}
}

