% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps-tidiers.R
\name{tidy.map}
\alias{tidy.map}
\alias{maps_tidiers}
\title{Tidy a(n) map object}
\usage{
\method{tidy}{map}(x, ...)
}
\arguments{
\item{x}{A \code{map} object returned from \code{\link[maps:map]{maps::map()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

library(maps)
library(ggplot2)


ca <- map("county", "ca", plot = FALSE, fill = TRUE)
tidy(ca)
qplot(long, lat, data = ca, geom = "polygon", group = group)

tx <- map("county", "texas", plot = FALSE, fill = TRUE)
tidy(tx)
qplot(long, lat,
  data = tx, geom = "polygon", group = group,
  colour = I("white")
)
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[maps:map]{maps::map()}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{term}{The name of the regression term.}
  \item{long}{Longitude.}
  \item{lat}{Latitude.}
Remaining columns give information on geographic attributes 
    and depend on the inputted map object. See ?maps::map for more information.
}
