% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muhaz-tidiers.R
\name{tidy.muhaz}
\alias{tidy.muhaz}
\alias{muhaz_tidiers}
\title{Tidy a(n) muhaz object}
\usage{
\method{tidy}{muhaz}(x, ...)
}
\arguments{
\item{x}{A \code{muhaz} object returned by \code{\link[muhaz:muhaz]{muhaz::muhaz()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

# feel free to ignore the following two lines—they allow {broom} to supply 
# examples without requiring the model/data-supplying packages to be installed.
if (requireNamespace("muhaz", quietly = TRUE)) {
  if (requireNamespace("survival", quietly = TRUE)) {

# load libraries for models and data
library(muhaz)
library(survival)

# fit model
x <- muhaz(ovarian$futime, ovarian$fustat)

# summarize model fit with tidiers
tidy(x)
glance(x)

  }
}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[muhaz:muhaz]{muhaz::muhaz()}}

Other muhaz tidiers: 
\code{\link{glance.muhaz}()}
}
\concept{muhaz tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{time}{Point in time.}
  \item{estimate}{Estimated hazard rate.}

}
